/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.tagvalidation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.gui.HListener;
import org.omegat.gui.common.OmegaTIcons;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.tagvalidation.TagValidationTool;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class TagValidationFrame
extends JFrame {
    public static final String FIX_URL_PREFIX = "fix:";
    private String message;
    private final JEditorPane m_editorPane;
    private List<ErrorReport> m_errorList;
    private JButton m_fixAllButton;
    private int m_numFixableErrors;

    public TagValidationFrame(MainWindow parent) {
        this.setTitle(OStrings.getString("TF_NOTICE_BAD_TAGS"));
        OmegaTIcons.setIconImages(this);
        this.initWindowLayout();
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagValidationFrame.this.doCancel();
            }
        };
        StaticUIUtils.setEscapeAction(this, (Action)escapeAction);
        JButton closeButton = new JButton();
        Mnemonics.setLocalizedText(closeButton, OStrings.getString("BUTTON_CLOSE"));
        closeButton.addActionListener(escapeAction);
        JButton refreshButton = new JButton();
        Mnemonics.setLocalizedText(refreshButton, OStrings.getString("BUTTON_REFRESH"));
        refreshButton.addActionListener(ev -> this.displayErrorList(new TagValidationTool().listInvalidTags()));
        this.m_fixAllButton = new JButton();
        Mnemonics.setLocalizedText(this.m_fixAllButton, OStrings.getString("BUTTON_FIX_ALL"));
        this.m_fixAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 != JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), StringUtil.format(OStrings.getString("TAG_FIX_ALL_WARNING"), TagValidationFrame.this.m_numFixableErrors), OStrings.getString("CONFIRM_DIALOG_TITLE"), 0)) {
                    return;
                }
                List fixed = TagValidationFrame.this.fixAllEntries();
                Core.getEditor().refreshViewAfterFix(fixed);
            }
        });
        this.m_editorPane = new JEditorPane();
        this.m_editorPane.setEditable(false);
        this.m_editorPane.addHyperlinkListener(new HListener(parent, this, true));
        StaticUIUtils.setCaretUpdateEnabled(this.m_editorPane, false);
        JScrollPane scroller = new JScrollPane(this.m_editorPane);
        Box bbut = Box.createHorizontalBox();
        bbut.add(Box.createHorizontalGlue());
        bbut.add(this.m_fixAllButton);
        bbut.add(Box.createHorizontalStrut(10));
        bbut.add(refreshButton);
        bbut.add(Box.createHorizontalStrut(10));
        bbut.add(closeButton);
        bbut.add(Box.createHorizontalGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroller, "Center");
        this.getContentPane().add((Component)bbut, "South");
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            @Override
            public void onFontChanged(Font newFont) {
                TagValidationFrame.this.setFont(newFont);
            }
        });
        this.setFont(Core.getMainWindow().getApplicationFont());
    }

    @Override
    public final void setFont(Font f) {
        super.setFont(f);
        if (this.isVisible()) {
            this.update();
        }
    }

    private void initWindowLayout() {
        try {
            String dx = Preferences.getPreference("tagv_window_x");
            String dy = Preferences.getPreference("tagv_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.setLocation(x, y);
            String dw = Preferences.getPreference("tagv_window_width");
            String dh = Preferences.getPreference("tagv_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            this.setSize(650, 700);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("tagv_window_width", this.getWidth());
        Preferences.setPreference("tagv_window_height", this.getHeight());
        Preferences.setPreference("tagv_window_x", this.getX());
        Preferences.setPreference("tagv_window_y", this.getY());
    }

    @Override
    public void processWindowEvent(WindowEvent w) {
        int evt = w.getID();
        if (evt == 201 || evt == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(w);
    }

    private void doCancel() {
        this.dispose();
    }

    private String htmlize(String str) {
        String htmld = str;
        htmld = htmld.replaceAll("\\<", "&lt;");
        htmld = htmld.replaceAll("\\>", "&gt;");
        htmld = htmld.replaceAll("\n", "<br>");
        return htmld;
    }

    private String colorTags(String str, Map<TagUtil.Tag, ErrorReport.TagError> errors) {
        StringBuilder html = new StringBuilder(str);
        ArrayList<TagUtil.Tag> tags = new ArrayList<TagUtil.Tag>(errors.keySet());
        Collections.sort(tags, new Comparator<TagUtil.Tag>(){

            @Override
            public int compare(TagUtil.Tag o1, TagUtil.Tag o2) {
                return o1.pos < o2.pos ? 1 : (o1.pos > o2.pos ? -1 : 0);
            }
        });
        int lastIndex = html.length();
        for (TagUtil.Tag tag : tags) {
            int end = tag.pos + tag.tag.length();
            String tail = html.substring(end, lastIndex);
            html.replace(end, lastIndex, this.htmlize(tail));
            html.replace(tag.pos, end, this.colorize(this.htmlize(tag.tag), errors.get(tag)));
            lastIndex = tag.pos;
        }
        String head = html.substring(0, lastIndex);
        html.replace(0, lastIndex, this.htmlize(head));
        Matcher lfMatch = PatternConsts.HTML_BR.matcher(html);
        return lfMatch.replaceAll("<font color=\"blue\"><sup>L</sup>F<br></font>");
    }

    public void displayErrorList(List<ErrorReport> errorList) {
        this.m_errorList = errorList;
        this.update();
    }

    private void update() {
        this.m_numFixableErrors = 0;
        StringBuilder output = new StringBuilder();
        output.append("<html>\n");
        output.append("<head>\n");
        output.append("<style>\n");
        output.append("<style type=\"text/css\">\n");
        output.append("    <!--\n");
        output.append("    body {\n");
        output.append("            font-family: " + this.getFont().getName() + ";\n");
        output.append("            font-size: " + this.getFont().getSize() + "pt;\n");
        output.append("    }\n");
        output.append("    td {\n");
        output.append("            border: 1px solid gray;\n");
        output.append("    }\n");
        output.append("    -->\n");
        output.append("</style>\n");
        output.append("</head>\n");
        output.append("<body>\n");
        if (this.message != null) {
            output.append("<b>" + this.message + "</b>");
        }
        output.append("<table border=\"1\" cellspacing=\"1\" cellpadding=\"2\" width=\"100%\">\n");
        for (ErrorReport report : this.m_errorList) {
            output.append("<tr>");
            output.append("<td>");
            output.append("<a href=\"");
            output.append(report.entryNum);
            output.append("\"");
            output.append(">");
            output.append(report.entryNum);
            output.append("</a>");
            output.append("</td>");
            output.append("<td>");
            output.append(this.colorTags(report.source, report.srcErrors));
            output.append("</td>");
            output.append("<td>");
            output.append(this.colorTags(report.translation, report.transErrors));
            output.append("</td>");
            output.append("<td width=\"10%\">");
            HashSet<ErrorReport.TagError> allErrors = new HashSet<ErrorReport.TagError>(report.srcErrors.values());
            allErrors.addAll(report.transErrors.values());
            for (ErrorReport.TagError err : allErrors) {
                output.append(this.colorize(ErrorReport.localizedTagError(err), err));
                output.append("<br/>");
            }
            if (!allErrors.contains((Object)ErrorReport.TagError.UNSPECIFIED)) {
                output.append("<p align=\"right\">&rArr;&nbsp;<a href=\"fix:");
                output.append(report.entryNum);
                output.append("\">");
                output.append(OStrings.getString("TAG_FIX_COMMAND"));
                output.append("</a></p>");
                ++this.m_numFixableErrors;
            }
            output.append("</td>");
            output.append("</tr>\n");
        }
        output.append("</table>\n");
        output.append("</body>\n");
        output.append("</html>\n");
        this.m_fixAllButton.setEnabled(this.m_numFixableErrors > 0);
        this.m_editorPane.setContentType("text/html");
        this.m_editorPane.setText(output.toString());
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private String colorize(String text, ErrorReport.TagError error) {
        String color = "black";
        if (error != null) {
            switch (error) {
                case EXTRANEOUS: {
                    text = "<strike>" + (String)text + "</strike>";
                }
                case MISSING: 
                case MALFORMED: 
                case WHITESPACE: {
                    color = "red";
                    break;
                }
                case DUPLICATE: {
                    color = "purple";
                    break;
                }
                case ORPHANED: {
                    text = "<u>" + (String)text + "</u>";
                }
                case ORDER: {
                    color = "#FF8C00";
                    break;
                }
                case UNSPECIFIED: {
                    color = "blue";
                }
            }
        }
        return "<font color=\"" + color + "\"><b>" + (String)text + "</b></font>";
    }

    public String fixEntry(int entryNum) {
        ErrorReport report = null;
        for (int i = 0; i < this.m_errorList.size(); ++i) {
            report = this.m_errorList.get(i);
            if (report.entryNum != entryNum) continue;
            if (!this.doFix(report)) {
                JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TAG_FIX_ERROR_MESSAGE"), OStrings.getString("TAG_FIX_ERROR_TITLE"), 0);
                this.dispose();
                return null;
            }
            if (report.ste.getDuplicate() == SourceTextEntry.DUPLICATE.NONE) {
                this.m_errorList.remove(i);
                break;
            }
            this.m_errorList = Core.getTagValidation().listInvalidTags();
            break;
        }
        if (this.m_errorList != null && !this.m_errorList.isEmpty()) {
            this.update();
        } else {
            this.dispose();
        }
        return report != null ? report.source : null;
    }

    private List<Integer> fixAllEntries() {
        ArrayList<Integer> fixed = new ArrayList<Integer>();
        for (ErrorReport report : this.m_errorList) {
            if (!this.doFix(report) && report.ste.getDuplicate() != SourceTextEntry.DUPLICATE.NEXT) {
                JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TAG_FIX_ERROR_MESSAGE"), OStrings.getString("TAG_FIX_ERROR_TITLE"), 0);
                break;
            }
            fixed.add(report.entryNum);
        }
        this.dispose();
        return fixed;
    }

    private boolean doFix(ErrorReport report) {
        TMXEntry prevTrans = Core.getProject().getTranslationInfo(report.ste.getKey());
        if (!report.translation.equals(prevTrans.translation)) {
            return false;
        }
        String fixed = TagValidationTool.fixErrors(report);
        if (fixed != null) {
            PrepareTMXEntry tr = new PrepareTMXEntry();
            tr.source = report.ste.getSrcText();
            tr.translation = fixed;
            tr.note = prevTrans.note;
            Core.getProject().setTranslation(report.ste, tr, prevTrans.defaultTranslation, null);
        }
        return true;
    }
}

