/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.omegat.help.Help;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class FileUtil {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static long RENAME_RETRY_TIMEOUT = 3000L;
    private static int TEMP_DIR_ATTEMPTS = 10000;
    private static final Pattern RE_ABSOLUTE_WINDOWS = Pattern.compile("[A-Za-z]\\:(/.*)");
    private static final Pattern RE_ABSOLUTE_LINUX = Pattern.compile("/.*");

    public static void removeOldBackups(final File originalFile, int maxBackups) {
        try {
            File[] bakFiles = originalFile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.isDirectory() && f.getName().startsWith(originalFile.getName()) && f.getName().endsWith(".bak");
                }
            });
            if (bakFiles != null && bakFiles.length > maxBackups) {
                Arrays.sort(bakFiles, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        if (f2.lastModified() < f1.lastModified()) {
                            return -1;
                        }
                        if (f2.lastModified() > f1.lastModified()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                for (int i = maxBackups; i < bakFiles.length; ++i) {
                    bakFiles[i].delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void backupFile(File f) throws IOException {
        long fileMillis = f.lastModified();
        String str = new SimpleDateFormat("yyyyMMddHHmm").format(new Date(fileMillis));
        FileUtils.copyFile((File)f, (File)new File(f.getPath() + "." + str + ".bak"));
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new IOException("Source file to rename (" + from + ") doesn't exist");
        }
        if (to.exists()) {
            throw new IOException("Target file to rename (" + to + ") already exists");
        }
        long b = System.currentTimeMillis();
        while (!from.renameTo(to)) {
            long e = System.currentTimeMillis();
            if (e - b <= RENAME_RETRY_TIMEOUT) continue;
            throw new IOException("Error renaming " + from + " to " + to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        String result = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader rd = null;
        try {
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            rd = new BufferedReader(isr);
            result = IOUtils.toString((Reader)rd);
            rd.close();
            isr.close();
            fis.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(rd);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((InputStream)fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)rd);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)fis);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter wr = null;
        try {
            fos = new FileOutputStream(file);
            wr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            wr.write(text);
            ((Writer)wr).close();
            fos.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(wr);
            IOUtils.closeQuietly((OutputStream)fos);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)wr);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileWithEolConversion(File inFile, File outFile, String eolConversionCharset) throws IOException {
        String eol;
        File dir = outFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((eol = outFile.exists() ? FileUtil.getEOL(outFile, eolConversionCharset) : Platform.getEOL()) == null) {
            FileUtils.copyFile((File)inFile, (File)outFile, (boolean)false);
            return;
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader in = null;
        try {
            fis = new FileInputStream(inFile);
            isr = new InputStreamReader((InputStream)fis, eolConversionCharset);
            in = new BufferedReader(isr);
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            BufferedWriter out = null;
            try {
                String s;
                fos = new FileOutputStream(outFile);
                osw = new OutputStreamWriter((OutputStream)fos, eolConversionCharset);
                out = new BufferedWriter(osw);
                while ((s = in.readLine()) != null) {
                    out.write(s);
                    out.write(eol);
                }
                out.close();
                osw.close();
                fos.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(osw);
                IOUtils.closeQuietly((OutputStream)fos);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)out);
            IOUtils.closeQuietly((Writer)osw);
            IOUtils.closeQuietly((OutputStream)fos);
            in.close();
            isr.close();
            fis.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((InputStream)fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEOL(File file, String eolConversionCharset) throws IOException {
        Object r = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader in = null;
        try {
            int ch;
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, eolConversionCharset);
            in = new BufferedReader(isr);
            while ((ch = in.read()) >= 0) {
                if (ch != 10 && ch != 13) continue;
                r = Character.toString((char)ch);
                int ch2 = in.read();
                if (ch2 != 10 && ch2 != 13) break;
                r = (String)r + Character.toString((char)ch2);
                break;
            }
            in.close();
            isr.close();
            fis.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((InputStream)fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)fis);
        return r;
    }

    public static List<File> findFiles(File dir, FileFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        HashSet<String> knownDirs = new HashSet<String>();
        FileUtil.findFiles(dir, filter, result, knownDirs);
        return result;
    }

    private static void findFiles(File dir, FileFilter filter, List<File> result, Set<String> knownDirs) {
        try {
            String curr_dir = dir.getCanonicalPath();
            if (!knownDirs.add(curr_dir)) {
                return;
            }
        }
        catch (IOException ex) {
            Log.log(ex);
            return;
        }
        File[] list = dir.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isDirectory()) {
                    FileUtil.findFiles(f, filter, result, knownDirs);
                    continue;
                }
                if (!filter.accept(f)) continue;
                result.add(f);
            }
        }
    }

    public static String computeRelativePath(File rootDir, File file) throws IOException {
        String rootAbs = rootDir.getAbsolutePath().replace('\\', '/') + "/";
        String fileAbs = file.getAbsolutePath().replace('\\', '/');
        switch (Platform.getOsType()) {
            case WIN32: 
            case WIN64: {
                if (fileAbs.toUpperCase().startsWith(rootAbs.toUpperCase())) break;
                throw new IOException("File '" + file + "' is not under dir '" + rootDir + "'");
            }
            default: {
                if (fileAbs.startsWith(rootAbs)) break;
                throw new IOException("File '" + file + "' is not under dir '" + rootDir + "'");
            }
        }
        return fileAbs.substring(rootAbs.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextFileFromDoc(String textFile) {
        URI uri = Help.getHelpFileURI(null, textFile);
        if (uri == null) {
            return null;
        }
        String result = null;
        BufferedReader rd = null;
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = uri.toURL().openStream();
            isr = new InputStreamReader(is, "UTF-8");
            rd = new BufferedReader(isr);
            result = IOUtils.toString((Reader)rd);
            rd.close();
            isr.close();
            is.close();
        }
        catch (IOException ex) {
            try {
                Log.log(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(rd);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(isr);
                throw throwable;
            }
            IOUtils.closeQuietly(rd);
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((Reader)isr);
        }
        IOUtils.closeQuietly((Reader)rd);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)isr);
        return result;
    }

    public static boolean deleteTree(File dir) {
        if (!dir.exists()) {
            return false;
        }
        if (dir.delete()) {
            return true;
        }
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                FileUtil.deleteTree(file);
            }
        }
        return dir.delete();
    }

    public static void copyFilesTo(File destination, File[] toCopy, ICollisionCallback onCollision) throws IOException {
        if (destination.exists() && !destination.isDirectory()) {
            throw new IOException("Copy-to destination exists and is not a directory.");
        }
        Map<File, File> collisions = FileUtil.copyFilesTo(destination, toCopy, (File)null);
        if (collisions.isEmpty()) {
            return;
        }
        ArrayList<File> toReplace = new ArrayList<File>();
        ArrayList<File> toDelete = new ArrayList<File>();
        int count = 0;
        for (Map.Entry<File, File> e : collisions.entrySet()) {
            if (onCollision != null && onCollision.isCanceled()) break;
            if (onCollision == null || onCollision.shouldReplace(e.getValue(), count, collisions.size())) {
                toReplace.add(e.getKey());
                toDelete.add(e.getValue());
            }
            ++count;
        }
        if (onCollision == null || !onCollision.isCanceled()) {
            for (File file : toDelete) {
                FileUtil.deleteTree(file);
            }
            FileUtil.copyFilesTo(destination, toReplace.toArray(new File[toReplace.size()]), (File)null);
        }
    }

    private static Map<File, File> copyFilesTo(File destination, File[] toCopy, File root) throws IOException {
        LinkedHashMap<File, File> collisions = new LinkedHashMap<File, File>();
        for (File file : toCopy) {
            if (destination.getPath().startsWith(file.getPath())) continue;
            File thisRoot = root == null ? file.getParentFile() : root;
            String filePath = file.getPath();
            String relPath = filePath.substring(thisRoot.getPath().length(), filePath.length());
            File dest = new File(destination, relPath);
            if (file.equals(dest)) continue;
            if (dest.exists()) {
                collisions.put(file, dest);
                continue;
            }
            if (file.isDirectory()) {
                FileUtil.copyFilesTo(destination, file.listFiles(), thisRoot);
                continue;
            }
            FileUtils.copyFile((File)file, (File)dest);
        }
        return collisions;
    }

    public static String interpolated(String file) {
        return file.replace("${omegat.home}", StaticUtils.installDir()).replace("${user.home}", System.getProperty("user.home"));
    }

    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < TEMP_DIR_ATTEMPTS; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within " + TEMP_DIR_ATTEMPTS + " attempts (tried " + baseName + "0 to " + baseName + (TEMP_DIR_ATTEMPTS - 1) + ")");
    }

    public static String getFileExtension(String path) {
        String basename = new File(path.replace('\\', '/')).getName();
        int i = basename.indexOf(46);
        return i < 1 ? "" : basename.substring(i + 1);
    }

    public static boolean isRelative(String path) {
        if (RE_ABSOLUTE_LINUX.matcher(path = path.replace('\\', '/')).matches()) {
            return false;
        }
        return !RE_ABSOLUTE_WINDOWS.matcher(path).matches();
    }

    public static String absoluteForSystem(String path, Platform.OsType currentOsType) {
        Matcher m = RE_ABSOLUTE_WINDOWS.matcher(path = path.replace('\\', '/'));
        if (m.matches() && currentOsType != Platform.OsType.WIN32 && currentOsType != Platform.OsType.WIN64) {
            return m.group(1);
        }
        return path;
    }

    public static interface ICollisionCallback {
        public boolean isCanceled();

        public boolean shouldReplace(File var1, int var2, int var3);
    }
}

