/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.omegat.util.Platform;

public class StaticUIUtils {
    private static final KeyStroke ESC_KEYSTROKE = KeyStroke.getKeyStroke(27, 0, false);

    public static void setEscapeClosable(JDialog dialog) {
        StaticUIUtils.setEscapeAction(dialog.getRootPane(), (Action)StaticUIUtils.makeCloseAction(dialog));
    }

    public static void setEscapeClosable(JFrame frame) {
        StaticUIUtils.setEscapeAction(frame.getRootPane(), (Action)StaticUIUtils.makeCloseAction(frame));
    }

    public static AbstractAction makeCloseAction(final Window window) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        };
    }

    public static void setEscapeAction(JDialog dialog, Action action) {
        StaticUIUtils.setEscapeAction(dialog.getRootPane(), action);
    }

    public static void setEscapeAction(JFrame frame, Action action) {
        StaticUIUtils.setEscapeAction(frame.getRootPane(), action);
    }

    public static void setEscapeAction(JRootPane pane, Action action) {
        pane.getInputMap(2).put(ESC_KEYSTROKE, "ESCAPE");
        pane.getActionMap().put("ESCAPE", action);
    }

    public static String truncateToFit(String text, JComponent comp, int margin) {
        int newWidth;
        int middle;
        if (text == null || ((String)text).isEmpty() || comp == null) {
            return text;
        }
        int targetWidth = comp.getWidth();
        if (targetWidth < 1) {
            return text;
        }
        Graphics graphics = comp.getGraphics();
        if (graphics == null) {
            return text;
        }
        FontMetrics metrics = graphics.getFontMetrics();
        int fullWidth = metrics.stringWidth((String)text);
        if (fullWidth + margin < targetWidth) {
            return text;
        }
        int truncateCharWidth = metrics.charWidth('\u2026');
        int chompStart = middle = ((String)text).offsetByCodePoints(0, ((String)text).codePointCount(0, ((String)text).length()) / 2);
        int chompEnd = middle;
        String chomp = null;
        while (chompStart != 0 && chompEnd != ((String)text).length() && (newWidth = fullWidth - metrics.stringWidth(chomp = ((String)text).substring(chompStart, chompEnd)) + truncateCharWidth + margin) > comp.getWidth()) {
            chompStart = ((String)text).offsetByCodePoints(chompStart, -1);
            chompEnd = ((String)text).offsetByCodePoints(chompEnd, 1);
        }
        if (chomp != null) {
            text = ((String)text).substring(0, chompStart) + "\u2026" + ((String)text).substring(chompEnd, ((String)text).length());
        }
        return text;
    }

    public static void forwardMouseWheelEvent(Component target, MouseWheelEvent evt) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseWheelEvent(target, evt.getID(), evt.getWhen(), evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger(), evt.getScrollType(), evt.getScrollAmount(), evt.getWheelRotation()));
    }

    public static void fitInScreen(Component comp) {
        Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (comp.getHeight() > rect.height) {
            comp.setSize(comp.getWidth(), rect.height);
        }
    }

    public static void setCaretUpdateEnabled(JTextComponent comp, boolean updateEnabled) {
        Caret caret = comp.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(updateEnabled ? 0 : 1);
        }
    }

    public static FocusListener makeCaretAlwaysVisible(final JTextComponent comp) {
        FocusAdapter listener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Caret caret = comp.getCaret();
                caret.setVisible(true);
                caret.setSelectionVisible(true);
            }
        };
        comp.addFocusListener(listener);
        return listener;
    }

    public static int correctFrameWidth(int width) {
        if (Platform.isMacOSX() && System.getProperty("java.version").startsWith("1.8")) {
            int screenWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width;
            width = Math.min(width, screenWidth - 50);
        }
        return width;
    }
}

