/*
 * Decompiled with CFR 0.152.
 */
package de.abelssoft.wordtools.jwordsplitter;

import de.abelssoft.tools.FileTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWordSplitter {
    private static final String COMMENT_CHAR = "#";
    private static final String DELIMITER_CHAR = "|";
    private final Map<String, List<String>> exceptionMap = new HashMap<String, List<String>>();
    private Set<String> words = null;
    private boolean hideConnectingCharacters = true;
    private boolean strictMode = false;
    private boolean reverseMode = false;
    protected String plainTextDictFile = null;
    protected InputStream plainTextDict = null;

    protected abstract Set<String> getWordList() throws IOException;

    protected abstract int getMinimumWordLength();

    protected abstract Collection<String> getConnectingCharacters();

    public AbstractWordSplitter(boolean hideConnectingCharacters) throws IOException {
        this(hideConnectingCharacters, (String)null);
    }

    public AbstractWordSplitter(boolean hideConnectingCharacters, String plainTextDictFile) throws IOException {
        this.hideConnectingCharacters = hideConnectingCharacters;
        this.plainTextDictFile = plainTextDictFile;
        this.words = this.getWordList();
    }

    public AbstractWordSplitter(boolean hideConnectingCharacters, InputStream plainTextDict) throws IOException {
        this.hideConnectingCharacters = hideConnectingCharacters;
        this.plainTextDict = plainTextDict;
        this.words = this.getWordList();
    }

    public AbstractWordSplitter() throws IOException {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionFile(String filename) throws IOException {
        InputStream is = AbstractWordSplitter.class.getResourceAsStream(filename);
        try {
            if (is == null) {
                throw new IOException("Cannot locate exception list in JAR: " + filename);
            }
            String exceptions = FileTools.loadFile(is, "UTF-8");
            Scanner scanner = new Scanner(exceptions);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.startsWith(COMMENT_CHAR)) continue;
                String[] parts = line.split("\\|");
                String completeWord = line.replace(DELIMITER_CHAR, "");
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(parts));
                this.exceptionMap.put(completeWord.toLowerCase(), list);
            }
            scanner.close();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void addException(String completeWord, List<String> wordParts) {
        this.exceptionMap.put(completeWord.toLowerCase(), wordParts);
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public void setReverseMode(boolean reverseMode) {
        this.reverseMode = reverseMode;
    }

    private boolean isWord(String s) {
        if (s == null) {
            return false;
        }
        if (s.trim().length() < this.getMinimumWordLength()) {
            return false;
        }
        return this.words.contains(s.toLowerCase().trim());
    }

    public Collection<String> splitWord(String str) {
        ArrayList<String> result = new ArrayList<String>();
        if (str == null) {
            return result;
        }
        String s = str.trim();
        if (s.length() < 2) {
            result.add(s);
            return result;
        }
        Collection<String> tuple = this.findTuple(s);
        if (tuple == null && !this.strictMode) {
            tuple = this.truncateSplit(s);
        }
        if (tuple == null && !this.strictMode) {
            tuple = this.truncateSplitReverse(s);
        }
        if (tuple == null) {
            result.add(str);
        } else {
            result.addAll(tuple);
        }
        return result;
    }

    private Collection<String> truncateSplit(String s) {
        for (int i = 0; i < s.length() - 2; ++i) {
            Collection<String> tmp = this.findTuple(s.substring(i));
            if (tmp == null) continue;
            ArrayList<String> tmp2 = new ArrayList<String>();
            if (this.strictMode && !this.isWord(s.substring(0, i))) continue;
            tmp2.add(s.substring(0, i));
            tmp2.addAll(tmp);
            return tmp2;
        }
        return null;
    }

    private Collection<String> truncateSplitReverse(String s) {
        for (int i = s.length() - 1; i > 1; --i) {
            Collection<String> tmp = this.findTuple(s.substring(0, i));
            if (tmp == null || this.strictMode && !this.isWord(s.substring(i))) continue;
            tmp.add(s.substring(i));
            return tmp;
        }
        return null;
    }

    private String removeTailingCharacters(String str) {
        String lowercaseStr = str.toLowerCase();
        Collection<String> connChars = this.getConnectingCharacters();
        for (String connChar : connChars) {
            if (!lowercaseStr.endsWith(connChar)) continue;
            return str.substring(0, str.length() - connChar.length());
        }
        return str;
    }

    private Collection<String> findTuple(String s) {
        ArrayList<String> result;
        block13: {
            Collection<String> rightCol;
            List<String> exceptionSplit = this.exceptionMap.get(s.toLowerCase());
            if (exceptionSplit != null) {
                return exceptionSplit;
            }
            if (s.length() < 2) {
                return null;
            }
            result = new ArrayList<String>();
            int fromPos = this.reverseMode ? s.length() - 1 : 0;
            int i = fromPos;
            while (true) {
                if (this.reverseMode) {
                    if (i < 1) break block13;
                    --i;
                } else {
                    if (i >= s.length()) break block13;
                    ++i;
                }
                String left = s.substring(0, i);
                String right = s.substring(left.length());
                String leftCleaned = this.removeTailingCharacters(left);
                boolean leftIsWord = false;
                if (this.isWord(leftCleaned)) {
                    if (this.hideConnectingCharacters) {
                        result.add(leftCleaned);
                    } else {
                        result.add(left);
                    }
                    leftIsWord = true;
                } else if (this.isWord(left)) {
                    result.add(left);
                    leftIsWord = true;
                }
                if (!leftIsWord) continue;
                rightCol = this.findTuple(right);
                if (rightCol != null) break;
                result = new ArrayList();
            }
            result.addAll(rightCol);
            return result;
        }
        boolean stringIsWord = this.isWord(s);
        boolean cleanedStringIsWord = this.isWord(this.removeTailingCharacters(s));
        if (!stringIsWord && !cleanedStringIsWord) {
            return null;
        }
        if (this.hideConnectingCharacters && !stringIsWord) {
            result.add(this.removeTailingCharacters(s));
        } else {
            result.add(s);
        }
        return result;
    }
}

