/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators.net;

import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.machinetranslators.CachedTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.WikiGet;

public class ApertiumTranslate
extends CachedTranslate {
    protected static String GT_URL = "https://www.apertium.org/apy/translate?q=";
    protected static String GT_URL2 = "&markUnknown=no&langpair=#sourceLang#|#targetLang#&key=bwuxb5jS+VwSJ8mLz1qMfmMrDGA";
    protected static String MARK_BEG = "{\"translatedText\": \"";
    protected static String MARK_END = "\"}";
    protected static Pattern RE_UNICODE = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");
    protected static Pattern RE_HTML = Pattern.compile("&#([0-9]+);");
    protected static Pattern RE_DETAILS = Pattern.compile("\"responseDetails\"\\s*:\\s*\"([^\"]+)");
    protected static Pattern RE_STATUS = Pattern.compile("\"responseStatus\"\\s*:\\s*([0-9]+)");

    protected String getPreferenceName() {
        return "allow_apertium_translate";
    }

    public String getName() {
        return OStrings.getString((String)"MT_ENGINE_APERTIUM");
    }

    private String apertiumCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase();
        String locale = language.getLocaleCode();
        if (!StringUtil.isEmpty((String)language.getCountryCode())) {
            if (locale.equalsIgnoreCase("en_us") || locale.equalsIgnoreCase("pt_br")) {
                return locale;
            }
            if (locale.equalsIgnoreCase("oc_ar")) {
                return "oc_aran";
            }
            if (locale.equalsIgnoreCase("ca_va")) {
                return "ca_valencia";
            }
        }
        return lCode;
    }

    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        char c;
        String g;
        Matcher m;
        String trText = text;
        String sourceLang = this.apertiumCode(sLang);
        String targetLang = this.apertiumCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang);
        String url = GT_URL + URLEncoder.encode(trText, "UTF-8") + url2;
        String v = WikiGet.getURLNoCert((String)url);
        while ((m = RE_UNICODE.matcher(v)).find()) {
            g = m.group();
            c = (char)Integer.parseInt(m.group(1), 16);
            v = v.replace(g, Character.toString(c));
        }
        v = v.replace("&quot;", "&#34;");
        v = v.replace("&nbsp;", "&#160;");
        v = v.replace("&amp;", "&#38;");
        v = v.replace("\\\"", "\"");
        while ((m = RE_HTML.matcher(v)).find()) {
            g = m.group();
            c = (char)Integer.parseInt(m.group(1));
            v = v.replace(g, Character.toString(c));
        }
        int beg = v.indexOf(MARK_BEG) + MARK_BEG.length();
        int end = v.indexOf(MARK_END, beg);
        if (end < 0) {
            Matcher m2 = RE_DETAILS.matcher(v);
            if (!m2.find()) {
                return "";
            }
            String details = m2.group(1);
            String code = "";
            m2 = RE_STATUS.matcher(v);
            if (m2.find()) {
                code = m2.group(1);
            }
            throw new Exception(StringUtil.format((String)OStrings.getString((String)"APERTIUM_ERROR"), (Object[])new Object[]{code, details}));
        }
        String tr = v.substring(beg, end);
        return tr;
    }
}

