/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.history;

import java.util.ArrayList;
import java.util.List;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.util.Preferences;
import org.trie4j.patricia.PatriciaTrie;

public class WordCompleter {
    static final int DEFAULT_MIN_CHARS = 3;
    int minSeedLength = Preferences.getPreferenceDefault((String)"history_completer_min_chars", (int)3);
    private PatriciaTrie data;

    void reset() {
        this.data = new PatriciaTrie();
    }

    void train(String text, String[] tokens) {
        if (text.codePointCount(0, text.length()) >= this.minSeedLength + 1) {
            for (String token : tokens) {
                if (token.codePointCount(0, token.length()) <= this.minSeedLength) continue;
                this.data.insert(token);
            }
        }
    }

    List<AutoCompleterItem> completeWord(String seed) {
        if (this.data == null || seed.codePointCount(0, seed.length()) < this.minSeedLength) {
            return new ArrayList<AutoCompleterItem>(1);
        }
        ArrayList<AutoCompleterItem> result = new ArrayList<AutoCompleterItem>();
        for (String s : this.data.predictiveSearch(seed)) {
            if (s.equalsIgnoreCase(seed)) continue;
            result.add(new AutoCompleterItem(s, null, seed.length()));
        }
        return result;
    }
}

