/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public final class MorfologikUkrainianSpellerRule
extends MorfologikSpellerRule {
    private static final String ABBREVIATION_CHAR = ".";
    private static final String COMPOUND_CHAR = "-";
    private static final String RESOURCE_FILENAME = "/uk/hunspell/uk_UA.dict";
    private static final Pattern UKRAINIAN_LETTERS = Pattern.compile(".*[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490].*");

    public MorfologikUkrainianSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_UK_UA";
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        String word = tokens[idx].getToken();
        if (!UKRAINIAN_LETTERS.matcher(word).matches()) {
            return true;
        }
        if (super.ignoreToken(tokens, idx)) {
            return true;
        }
        if (idx < tokens.length - 1 && tokens[idx + 1].getToken().equals(ABBREVIATION_CHAR)) {
            if (super.ignoreWord(word + ABBREVIATION_CHAR)) {
                return true;
            }
            if (word.matches("[\u0410-\u042f\u0406\u0407\u0404\u0490]")) {
                return true;
            }
        }
        return false;
    }

    protected boolean isMisspelled(MorfologikSpeller speller, String word) {
        if (!super.isMisspelled(speller, word)) {
            return false;
        }
        if (word.contains(COMPOUND_CHAR)) {
            String[] words;
            for (String singleWord : words = word.split(COMPOUND_CHAR)) {
                if (!speller.isMisspelled(singleWord)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

