/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.io;

import java.io.IOException;
import net.moraleboost.io.CodePointReader;

public class PushbackCodePointReader
implements CodePointReader {
    private CodePointReader reader = null;
    private int[] codepoints = null;
    private int[] lengths = null;
    private int offset = 0;
    private int stackpos = -1;

    public PushbackCodePointReader(CodePointReader reader, int size) {
        this.reader = reader;
        this.codepoints = new int[size];
        this.lengths = new int[size];
    }

    public void setAlternationCodePoint(int cp) {
        this.reader.setAlternationCodePoint(cp);
    }

    public int getAlternationCodePoint() {
        return this.reader.getAlternationCodePoint();
    }

    public long getPosition() {
        return this.reader.getPosition() - (long)this.offset;
    }

    public int getStackSize() {
        return this.codepoints.length;
    }

    public int read() throws IOException {
        if (this.stackpos >= 0) {
            this.offset -= this.lengths[this.stackpos];
            return this.codepoints[this.stackpos--];
        }
        return this.reader.read();
    }

    public void reset() {
        this.reader.reset();
        this.stackpos = -1;
    }

    public void unread(int cp, int length) throws IOException {
        if (this.stackpos + 1 >= this.codepoints.length) {
            throw new IOException("Stack overflow.");
        }
        ++this.stackpos;
        this.codepoints[this.stackpos] = cp;
        this.lengths[this.stackpos] = length;
        this.offset += length;
    }
}

