result.appendSource(entry.srcText).append(": ");

def translations  = entry.getLocTerms(true)
def count = translations.size() - 1

translations.each { tra ->
    def merged = entry.getEntriesFor(tra)

    // Add target text, encapsulated in tooltip
	result.startTooltip(String.join(",", merged.collect { it.origin.longName }));	// tooltip for target = all origins for this target
	result.appendTarget(tra, entry.hasPriorities(tra));
	result.endTooltip();

    // Add notes (to stay compact, we add only notes)
    def commentsList = merged.collect { it.noteText }.findAll { (it != null) && (it.length() > 0) }.unique()
    if (commentsList.size() > 0) {
        result.appendComment(" (");
	    for (com in commentsList) if ((com != null) && (com.length() > 0)) {
		    result.appendComment(com).append ("; "); 
	    }
        result.appendComment(") ");
    }
	
	if (count-- > 0) result.append(",");
}

result.append("\n\n");