<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:template match="/">
		<html><body>
			<dl>
				<xsl:for-each select="//entry">
					<dt>
						<xsl:value-of select="./attributes/tm" />, <xsl:value-of select="./attributes/docno" />
						(<xsl:value-of select="./attributes/doctype" />; source: <xsl:value-of select="./attributes/source" />)
					</dt>
					<dd>
						<dl>
						<xsl:for-each select="sentences/sentence">
							<dt><xsl:value-of select="@matid" /></dt>
							<dd>
								<dl>
									<xsl:for-each select="original">
										<dt><xsl:value-of select="@language" /></dt>
										<dd>
											<xsl:for-each select="./node()">
												<xsl:choose>
													<xsl:when test="name() = 'found'">
														<font color="blue"><xsl:value-of select="./text()" /></font>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="." />
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</dd>
									</xsl:for-each>
									<xsl:for-each select="translation ">
										<dt><xsl:value-of select="@language" /></dt>
										<dd>
											<xsl:copy-of select="./text()" />
										</dd>
									</xsl:for-each>
								</dl>
							</dd>
						</xsl:for-each>
						</dl>
					</dd>
				</xsl:for-each>
			</dl>
		</body></html>
	</xsl:template>

</xsl:stylesheet>